	function wcT = CA_wcT_Z(N, wsT, Amax, Amin)
	
	% 	Computes wcT for a lowpass digital Cauer filter of order N
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramaki, 2018-03-10
	% 	Modified by: 	LW, 2018-04-04
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	tapio.saramaki@tut.fi
	
	if N ~= round(N)
		disp([ 'Must be an integer'])
		break
	end
	JJ = sqrt(sqrt((10^(Amin/10)-1))/sqrt((10^(Amax/10)-1)));
    for k = 1:4
        JJ = JJ*JJ;
        if JJ <= 10^150 
            JJ = JJ+sqrt(JJ*JJ-1);
		else
            JJ = 2*JJ;
		end
	end
    A = (JJ/(2^(N-1)))^(1/N);
    for k = 1:4
        A = sqrt((A+1/A)/2);
	end
    wcT = 2*atan(tan(wsT/2)/(A^2))/pi;
	
	
